<?php
// Wczytanie środowiska WordPress.
// Umieść ten plik w katalogu głównym instalacji WordPress (tam, gdzie znajduje się plik wp-load.php).
require('./wp-load.php');
?>
<?php

// Pobranie obiektu SimplePie ze źródła wiadomości RSS.
$rss = fetch_feed('http://planetozh.com/blog/feed/');

// Upewnienie się o prawidłowym utworzeniu obiektu SimplePie.
if( is_wp_error( $rss ) )
    wp_die( 'Nie można pobrać wiadomości' );
    
echo 'Znaleziono wiadomości, zawierają '. $rss->get_item_quantity() . ' artykułów.';

// Utworzenie tablicy pięciu elementów, począwszy od elementu #0.
$rss_items = $rss->get_items( 0, 5 );

// Początek uporządkowanej listy.
echo '<ol>';

// Iteracja przez wszystkie elementy i wyświetlenie tytułu, daty publikacji i odnośnika do artykułu.
foreach( $rss_items as $item ) {
    $title = $item->get_title();
    $date  = $item->get_date('Y/m/d @ g:i a');
    $link  = $item->get_permalink();

    echo "<li><a href='$link'>$title</a> ($date)</li>\n";
}

// Koniec uporządkowanej listy.
echo '</ol>';
