<?php
/*
Plugin Name: Ograniczenie możliwości edycji wpisów bloga administratora
Plugin URI: http://przyklad.pl
Description: Tylko administratorzy mogą edytować wpisy bloga utworzone przez administratorów.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Zarejestrowanie funkcji dla zaczepu filtru map_meta_cap. */
add_filter( 'map_meta_cap', 'boj_restrict_admin_post_editing', 10, 4 );

/* Funkcja ograniczająca użytkownikom możliwość edycji wpisów bloga administratorów. */
function boj_restrict_admin_post_editing( $caps, $cap, $user_id, $args ) {

    /* Jeżeli użytkownik próbuje przeprowadzić edycję wpisu bloga lub go usunąć. */
    if ( 'edit_post' == $cap || 'delete_post' == $cap ) {

        /* Pobranie obiektu wpisu bloga. */
        $post = get_post( $args[0] );

        /* Jeżeli administrator jest autorem wpisu bloga. */
        if ( author_can( $post, 'delete_users' ) ) {

            /* Dodanie możliwości, że tylko administratorzy mogą usuwać tablicę . */
            $caps[] = 'delete_users';
        }
    }

    /* Zwrócenie tablicy z możliwościami. */
    return $caps;
}

?>
