<?php
/*
Plugin Name: Role dla forum
Plugin URI: http://przyklad.pl
Description: Tworzy role i możliwości dla fikcyjnej wtyczki obsługi forum.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Utworzenie klasy ról i możliwości forum. */
class BOJ_Forum_Roles {

    /* Metoda konstruktora PHP4. */
    function BOJ_Forum_Roles() {

        /* Rejestracja zaczepu aktywacji wtyczki. */
        register_activation_hook( __FILE__, array( &$this, 'activation' ) );

        /* Rejestracja zaczepu dezaktywacji wtyczki. */
        register_deactivation_hook( __FILE__, array( &$this, 'deactivation' ) );
    }

    /* Metoda aktywacji wtyczki. */
    function activation() {

        /* Pobranie domyślnej roli administratora. */
        $role =& get_role( 'administrator' );

        /* Dodanie do roli administratora możliwości z zakresu obsługi forum. */
        if ( !empty( $role ) ) {
            $role->add_cap( 'publish_forum_topics' );
            $role->add_cap( 'edit_others_forum_topics' );
            $role->add_cap( 'delete_forum_topics' );
            $role->add_cap( 'read_forum_topics' );
        }

        /* Utworzenie roli administratora forum. */
        add_role(
            'forum_administrator',
            'Administrator forum',
            array(
                'publish_forum_topics',
                'edit_others_forum_topics',
                'delete_forum_topics',
                'read_forum_topics'
            )
        );

        /* Utworzenie roli moderatora forum. */
        add_role(
            'forum_moderator',
            'Moderator forum',
            array(
                'publish_forum_topics',
                'edit_others_forum_topics',
                'read_forum_topics'
            )
        );

        /* Utworzenie roli członka forum. */
        add_role(
            'forum_member',
            'Członek forum',
            array(
                'publish_forum_topics',
                'read_forum_topics'
            )
        );

        /* Utworzenie roli zawieszonego członka forum. */
        add_role(
            'forum_suspended',
            'Zawieszony członek forum',
            array( 'read_forum_topics' )
        );
    }

    /* Metoda dezaktywacji wtyczki. */
    function deactivation() {

        /* Pobranie domyślnej roli administratora. */
        $role =& get_role( 'administrator' );

        /* Usunięcie możliwości z roli administratora. */
        if ( !empty( $role ) ) {
            $role->remove_cap( 'publish_forum_topics' );
            $role->remove_cap( 'edit_others_forum_topics' );
            $role->remove_cap( 'delete_forum_topics' );
            $role->remove_cap( 'read_forum_topics' );
        }

        /* Przygotowanie tablicy ról do usunięcia. */
        $roles_to_delete = array(
            'forum_administrator',
            'forum_moderator',
            'forum_member',
            'forum_suspended'
        );

        /* Iteracja przez każdą rolę i jej usunięcie. */
        foreach ( $roles_to_delete as $role ) {

            /* Pobranie użytkowników roli. */
            $users = get_users( array( 'role' => $role ) );

            /* Sprawdzenie, czy w roli znajduje się jakikolwiek użytkownik. */
            if ( count( $users ) <= 0 ) {

                /* Usunięcie roli z witryny. */
                remove_role( $role );
            }
        }
    }
}

$forum_roles = new BOJ_Forum_Roles();

?>
