<?php
/*
Plugin Name: Przykład API Settings
Plugin URI: http://przyklad.pl/
Description: Pełny i praktyczny przykład użycia API Settings.
Author: WROX
Author URI: http://wrox.com
*/

// Dodanie menu dla strony opcji.
add_action('admin_menu', 'boj_myplugin_add_page');
function boj_myplugin_add_page() {
	add_options_page( 'My Plugin', 'Moja wtyczka', 'manage_options', 'boj_myplugin', 'boj_myplugin_option_page' );
}

// Wygenerowanie strony z opcjami.
function boj_myplugin_option_page() {
	?>
	<div class="wrap">
		<?php screen_icon(); ?>
		<h2>Moja wtyczka</h2>
		<form action="options.php" method="post">
			<?php settings_fields('boj_myplugin_options'); ?>
			<?php do_settings_sections('boj_myplugin'); ?>
			<input name="Submit" type="submit" value="Zapisz zmiany" />
		</form>
	</div>
	<?php
}

// Zarejestrowanie i zdefiniowanie ustawień.
add_action('admin_init', 'boj_myplugin_admin_init');
function boj_myplugin_admin_init(){
	register_setting(
		'boj_myplugin_options',
		'boj_myplugin_options',
		'boj_myplugin_validate_options'
	);
	add_settings_section(
		'boj_myplugin_main',
		'Ustawienia wtyczki',
		'boj_myplugin_section_text',
		'boj_myplugin'
	);
	add_settings_field(
		'boj_myplugin_text_string',
		'Podaj dowolny tekst',
		'boj_myplugin_setting_input',
		'boj_myplugin',
		'boj_myplugin_main'
	);
}

// Wygenerowanie nagłówka sekcji.
function boj_myplugin_section_text() {
	echo '<p>W tym miejscu zdefiniuj ustawienia.</p>';
}

// Wyświetlenie i wypełnienie pola formularza.
function boj_myplugin_setting_input() {
	// Pobranie z bazy danych wartości opcji 'text_string'.
	$options = get_option( 'boj_myplugin_options' );
	$text_string = $options['text_string'];
	// Wyświetlenie pola.
	echo "<input id='text_string' name='boj_myplugin_options[text_string]' type='text' value='$text_string' />";
}

// Weryfikacja danych wejściowych użytkownika (dozwolone jest podanie jedynie tekstu).
function boj_myplugin_validate_options( $input ) {
	$valid['text_string'] = preg_replace( '/[^a-zA-Z]/', '', $input['text_string'] );
	
	if( $valid['text_string'] != $input['text_string'] ) {
		add_settings_error(
			'boj_myplugin_text_string',
			'boj_myplugin_texterror',
			'Wprowadzono nieprawidłową wartość!',
			'error'
		);		
	}
	
	return $valid;
}

