<?php
/*
Plugin Name: Przykład API Alternate
Plugin URI: http://przykład.pl/
Description: Ta wtyczka sprawdza dostępność nowej wersji wtyczki.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com/
*/

define( 'BOJ_ALT_API', 'http://127.0.0.1/plugin-api/' );

// Na potrzeby testów, magazyn witryny będzie zerowany podczas każdego wczytywania strony.
//add_action( 'init', 'boj_altapi_delete_transient' );
function boj_altapi_delete_transient() {
    delete_site_transient( 'update_plugins' );
}

// Dodanie funkcji aktualizacji wtyczki.
add_filter('pre_set_site_transient_update_plugins', 'boj_altapi_check');

function boj_altapi_check( $transient ) {

    // Sprawdzenie istnienia informacji 'checked'.
    // Jeżeli nie istnieją, wartością zwrotną jest po prostu wartość zmiennej.
    if( empty( $transient->checked ) )
        return $transient;
    
    // W przypadku istnienia informacji 'checked',
    // będą dołączone do informacji pochodzących z API.
    
    $plugin_slug = plugin_basename( __FILE__ );
    
    // Dane wysyłane do API.
    $args = array(
        'action' => 'update-check',
        'plugin_name' => $plugin_slug,
        'version' => $transient->checked[$plugin_slug],
    );
    
    // Wykonanie żądania sprawdzającego dostępność aktualizacji.
    $response = boj_altapi_request( $args );
    
    // Jeżeli odpowiedź jest negatywna, nie wprowadzamy żadnych zmian.
    if( false !== $response ) {
        $transient->response[$plugin_slug] = $response;
    }
    
    return $transient;
}

// Wykonanie żądania do alternatywnego API, wartością zwrotną jest obiekt.
function boj_altapi_request( $args ) {

    // Wykonanie żądania.
    $request = wp_remote_post( BOJ_ALT_API, array( 'body' => $args ) );
    
    // Upewniamy się, że wykonanie żądania zakończyło się powodzeniem.
    if( is_wp_error( $request )
    or
    wp_remote_retrieve_response_code( $request ) != 200
    ) {
        // Żądanie nieudane.
        return false;
    }
    
    // Odczyt odpowiedzi serwera, która powinna być obiektem.
    $response = unserialize( wp_remote_retrieve_body( $request ) );
    if( is_object( $response ) ) {
        return $response;
    } else {
        // Nieoczekiwana odpowiedź.
        return false;
    }
}


// Funkcja odpowiedzialna za wyświetlanie informacji na ekranie.
add_filter('plugins_api', 'boj_altapi_information', 10, 3);

function boj_altapi_information( $false, $action, $args ) {

    $plugin_slug = plugin_basename( __FILE__ );

    //Sprawdzenie czy to API dotyczy wtyczki.
    if( $args->slug != $plugin_slug ) {
        return false;
    }
        
    // Przekazanie danych do API.
    $args = array(
        'action' => 'plugin_information',
        'plugin_name' => $plugin_slug,
        'version' => $transient->checked[$plugin_slug],
    );
    
    // Wykonanie żądania pobierającego informacje szczegółowe.
    $response = boj_altapi_request( $args );
    
    // Wykonanie żądania sprawdzającego dostępność informacji.
    $request = wp_remote_post( BOJ_ALT_API, array( 'body' => $args ) );

    return $response;
}


