<?php
/*
Plugin Name: Wtyczka z poprawionymi błędami
Plugin URI: http://przyklad.pl
Description: Poprawione błędy z wtyczki "Wtyczka z błędami".
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Zaczep filtru 'the_content'. */
add_filter( 'the_content', 'boj_error_plugin_author_box' );

/* Dołączenie na końcu wpisów bloga informacji o autorze. */
function boj_error_plugin_author_box( $content ) {
    global $post;

    /* Jeżeli wyświetlany wpis bloga jest typu 'post'. */
    if ( 'post' == $post->post_type ) {

        /* Początek znacznika <div> informacji o autorze. */
        $author_box = '<div class="author-box">';

        /* Wyświetlenie danych autora. */
        $author_box .= '<h3>' . get_the_author_meta( 'display_name' ) . '</h3>';

        /* Wyświetlenie krótkiej notki o autorze. */
        $author_box .= '<p>' . get_the_author_meta( 'description' ) . '</p>';

        /* Zamknięcie znacznika. */
        $author_box .= '</div>';
    }

    /* Dołączenie informacji o autorze do treści wpisu bloga. */
    if ( isset( $author_box ) )
        $content = $content . $author_box;

    /* Zwrot treści wpisu bloga. */
    return $content;
}

?>
