<?php 
/*
Plugin Name: Wpisy bloga z sieci Multisite
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wyświetla ostatni wpisy bloga z wielu witryn sieci Multisite
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_shortcode( 'latest_network_posts', 'boj_multisite_latest_network_posts' );

function boj_multisite_latest_network_posts() {

	if ( is_multisite() ) {

		$return_posts = '';

		// Pobranie wpisów bloga z bieżącej witryny.
		$local_posts = get_posts( 'numberposts=5' );
		
		// Przejście do bloga o identyfikatorze 3.
		switch_to_blog( 3 );
		
		// Pobranie wpisów bloga z innej witryny.
		$network_posts = get_posts( 'numberposts=5' );
		
		// Przywrócenie bieżącej witryny.
		restore_current_blog();
		
		// Połączenie dwóch tablic w jedną.
		$posts = array_merge( $local_posts, $network_posts );
		
		// Posortowanie wpisów bloga względem daty publikacji. 
		usort( $posts, 'boj_multisite_sort_posts_array' );

		foreach ( $posts as $post ) {

			// Przechowywanie ostatnio opublikowanych wpisów bloga w zmiennej.
			$return_posts .= $post->post_title .' - opublikowany dnia ' .$post->post_date .'<br />';

		}
		
		// Zwrócenie wyników do wyświetlenia.
		return $return_posts;
		
	}

}

// Posortowanie tablicy względem daty.
function boj_multisite_sort_posts_array( $a, $b ) {

	// Jeżeli daty są takie same, wartością zwrotną ma być zero.
	if ($a->post_date == $b->post_date)
		return 0;
	
	// Operator trójargumentowy w celu określenia, która data jest nowsza.
	return $a->post_date < $b->post_date ? 1 : -1;

}
?>
