<?php
/*
Plugin Name: Ajax Czytaj dalej
Plugin URI: http://przyklad.pl/
Description: Obsługa odnośników "Czytaj dalej" za pomocą technologii Ajax.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com
*/

// Określenie, czy wstawienie skryptu jest konieczne.
global $boj_arm_needjs;
$boj_arm_needjs = false;

// Wersja wtyczki, po uaktualnieniu wtyczki należy zwiększyć numer wersji.
define( 'BOJ_ARM_VERSION', '1.0' );

// Umieszczenie skryptu JavaScript w kolejce skryptów do wstawienia w stopce strony.
add_action( 'template_redirect', 'boj_arm_add_js' );
function boj_arm_add_js() {

    // Umieszczenie skryptu w kolejce.
    wp_enqueue_script( 'boj_arm',
        plugin_dir_url( __FILE__ ).'js/script.js',
        array('jquery'), BOJ_ARM_VERSION, true
    );

    // Pobranie protokołu bieżącej strony.
    $protocol = isset( $_SERVER["HTTPS"]) ? 'https://' : 'http://';

    // Wyświetlenie strony admin-ajax.php z użyciem takiego samego protokołu jak na bieżącej stronie.
    $params = array(
      'ajaxurl' => admin_url( 'admin-ajax.php', $protocol )
    );
    wp_localize_script( 'boj_arm', 'boj_arm', $params );
}

// Nie dodawaj skryptu, jeśli faktycznie nie jest on potrzebny.
add_action( 'wp_print_footer_scripts', 'boj_arm_footer_maybe_remove', 1 );
function boj_arm_footer_maybe_remove() {
    global $boj_arm_needjs;
    if( !$boj_arm_needjs ) {
        wp_deregister_script( 'boj_arm' );
    }
}

// Przegląd każdego wpisu bloga i sprawdzenie, czy zawiera odnośnik "Czytaj dalej".
add_action( 'the_post', 'boj_arm_check_readmore' );
function boj_arm_check_readmore( $post ) {
    if ( preg_match('/<!--more(.*?)?-->/', $post->post_content )
    && !is_single() ) {
        global $boj_arm_needjs; 
        $boj_arm_needjs = true;
    }
}

// Obsługa żądania Ajax.
add_action('wp_ajax_nopriv_boj_arm_ajax', 'boj_arm_ajax');
add_action('wp_ajax_boj_arm_ajax', 'boj_arm_ajax');
function boj_arm_ajax() {
    // Modyfikacja sposobu pobierania treści wpisu bloga przez platformę WordPress.
    add_filter( 'the_content', 'boj_arm_get_2nd_half' );

    // Konfiguracja zapytania.
    query_posts( 'p='.absint( $_REQUEST['post_id'] ) );

    // Pętla.
    if ( have_posts() ) : while ( have_posts() ) : the_post();
        the_content();
    endwhile; else:
        echo "nie znaleziono wpisu bloga :/";
    endif;

    // Zerowanie zapytania.
    wp_reset_query();
    die();
}

// Pobranie tej części wpisu bloga, która znajduje się po odnośniku "Czytaj dalej".
function boj_arm_get_2nd_half( $content ) {
    $id = absint( $_REQUEST['post_id'] );
    $content = preg_replace( "!^.*<span id=\"more-$id\"></span>!s", '', $content );
    return $content;
}
?>
