<?php
/*
Plugin Name: Twitter Info
Plugin URI: http:// przyklad.pl/
Description: Pobranie liczby śledzących wskazanego użytkownika oraz jego ostatnią wiadomość opublikowaną w serwisie Twitter.
Author: WROX
Author URI: http://wrox.com
*/

// Zdefiniowanie nazwy użytkownika serwisu Twitter.
define( 'BOJ_TI_USERNAME', 'ozh' );

// Nazwa klucza używanego do buforowania wartości.
define( 'BOJ_TI_KEY', 'boj_ti_key' );

// Użycie API serwisu Twitter.
// Zwrot tablicy (liczba śledzących, ostatnia opublikowana wiadomość w serwisie) lub false w przypadku wystąpienia błędu.
function boj_ti_ask_twitter() {

    // Wykonanie żądania GET do API serwisu Twitter.
    $api_url = 'http://api.twitter.com/1/users/show.json?screen_name=';
    $api_response = wp_remote_get( $api_url . urlencode( BOJ_TI_USERNAME ) );
    
    // Pobranie obiektu JSON.
    $json = wp_remote_retrieve_body( $api_response );
    
    // Upewnienie się, że wykonanie żądania zakończyło się powodzeniem; w przeciwnym razie wartością zwrotną jest false.
    if( empty( $json ) )
        return false;
    
    // Dekodowanie obiektu JSON.
    // Zwrot tablicy zawierającej liczbę śledzących oraz ostatnią opublikowaną wiadomość w serwisie.
    $json = json_decode( $json );
    
    return array(
        'followers'  => $json->followers_count,
        'last_tweet' => $json->status->text
    );
}

// Zwrot tablicy zawierającej liczbę śledzących oraz ostatnią opublikowaną wiadomość w serwisie.
// Wynik jest pobierany z bufora lub następuje pobranie nowej wartości.
function boj_ti_get_infos( $info = 'followers' ) {
    
    // W pierwszej kolejności sprawdzamy, czy jest buforowany wynik.
    if ( false !== $cache = get_transient( BOJ_TI_KEY ) )
        return $cache[$info];
    
    // Brak buforowanego wyniku? Trzeba więc pobrać nową wartość.
    $fresh = boj_ti_ask_twitter();
    
    // Domyślny czas ważności bufora wynosi 1 godzinę (3600 sekund).
    $cache = 3600;

    // Jeżeli zapytanie do serwisu Twitter zakończy się niepowodzeniem, fikcyjne wartości będą przechowywane przez 5 minut.
    if( $fresh === false ) {
        $fresh = array(
            'followers' => 0,
            'last_tweet' => '',
        );
        $cache = 60*5;
    }
    
    // Przechowywanie wartości tymczasowej.
    set_transient( BOJ_TI_KEY, $fresh, 60*5 );
    
    // Zwrot nowych informacji.
    return $fresh[$info];
}

// Wyświetlenie liczby osób śledzących wskazanego użytkownika serwisu Twitter.
function boj_ti_followers() {
    $num = boj_ti_get_infos( 'followers' );
	echo "<p>W serwisie Twitter śledzi mnie $num osób!</p>";
}

// Wyświetlenie ostatniego opublikowanego komunikatu.
function boj_ti_last_tweet() {
    $tweet = boj_ti_get_infos( 'last_tweet' );
	echo "<p>Mój ostatni opublikowany komunikat: $tweet</p>";
}

// Rejestracja własnych akcji.
add_action( 'boj_ti_followers' , 'boj_ti_followers' );
add_action( 'boj_ti_last_tweet', 'boj_ti_last_tweet' );

?>
