<?php
/*
Plugin Name: Rejestracja żądań HTTP
Plugin URI: http://przyklad.pl/
Description: Każde żądanie HTTP jest rejestrowane w celu jego dalszej analizy.
Author: WROX
Author URI: http://wrox.com
*/

// Rejestracja funkcji w zaczepach.
add_filter( 'http_request_args', 'boj_loghttp_log_request', 10, 2 );
add_filter( 'http_response', 'boj_loghttp_log_response', 10, 3 );

// Rejestracja żądań.
// Parametry przekazane: parametry żądania i adres URL.
function boj_loghttp_log_request( $r, $url ) {

	// Pobranie parametrów żądania sformatowanych w celu wyświetlenia.
	$params = print_r( $r, true );
	
	// Pobranie daty w formacie 2010-11-25 @ 13:37:00.
	$date = date( 'Y-m-d @ H:i:s' );

	// Zapisanie danych w dzienniku zdarzeń:
	$log = <<<LOG
	$date: żądanie wysłane na adres $url
	Parametry: $params
	--------------
	
LOG;
	
	// Zapis danych w jednorodnym pliku tekstowym.
	error_log( $log, 3, dirname( __FILE__ ).'/http.log' );
	
	// Nie należy zapomnieć o zwróceniu argumentów żądania!
	return $r;
}

// Rejestracja odpowiedzi.
// Parametry przekazane: odpowiedź serwera, parametry żądania i adres URL.
function boj_loghttp_log_response( $response, $r, $url ) {
	
	// Pobranie odpowiedzi serwera sformatowanej w celu wyświetlenia.
	$resp = print_r( $response, true );

	// Pobranie daty w formacie 2010-11-25 @ 13:37:00.
	$date = date( 'Y-m-d @ H:i:s' );

	// Zapisanie danych w dzienniku zdarzeń:
	$log = <<<LOG
	$date: odpowiedź otrzymana z adresu $url
	Odpowiedź: $resp
	--------------
	
LOG;
	
	// Zapis danych w jednorodnym pliku tekstowym.
	error_log( $log, 3, dirname( __FILE__ ).'/http.log' );
	
	// Nie należy zapomnieć o zwróceniu odpowiedzi!
	return $response;

}
