<?php
/*
Plugin Name: Pobranie tytułu bieżącej piosenki
Plugin URI: http://przyklad.pl/
Description: Pobranie tytułu bieżącej piosenki z internetowego radio
Author: WROX
Author URI: http://wrox.com
*/

// Pobranie tytułu bieżącej piosenki w radio KNAC.
function boj_onair_fetch_song_title_from_radio() {
    $url = 'http://knac.com/text1.txt';

    $text = wp_remote_retrieve_body( wp_remote_get( $url ) );
    
    preg_match( '/\<current_song\>(.*)/', $text, $matches );
    $song = trim( $matches[1] );

    preg_match( '/\<current_artist\>(.*)/', $text, $matches );
    $artist = trim( $matches[1] );

    return "$song by $artist";
} 


// Pobranie tytułu piosenki z bazy danych i jej zwrócenie.
function boj_onair_get_song_title() {
	
	// Pobranie wartości.
	$title = get_transient( 'boj_onair_song' );
	
	// Jeśli wartość nie istnieje lub utraciła ważność, należy ją odświeżyć. 
	if( false === $title ) {
		$title = boj_onair_fetch_song_title_from_radio();
		set_transient( 'boj_onair_song', $title, 180 );
	}
	
	return $title;
}
