<?php 
/*
Plugin Name: Przykład zaawansowanej wtyczki tworzącej widget
Plugin URI: http://przyklad.pl/wtyczki-wordpresss/moja-wtyczka
Description: Wtyczka tworząca widget na platformie WordPress
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Użycie zaczepu akcji widgets_init w celu wykonania własnej funkcji.
add_action( 'widgets_init', 'boj_awe_register_widgets' );

// Rejestracja widgetu.
function boj_awe_register_widgets() {
    register_widget( 'boj_awe_widget' );
}

//boj_widget_my_info class
class boj_awe_widget extends WP_Widget {

    // Przetworzenie nowego widgetu.
    function boj_awe_widget() {
	
        $widget_ops = array( 
			'classname' => 'boj_awe_widget_class', 
			'description' => 'Wyświetla wiadomości RSS wraz z opcjami.' 
			); 
			
        $this->WP_Widget( 'boj_awe_widget', 'Zaawansowany widget RSS', $widget_ops );
    }
 
     // Zbudowanie formularza ustawień widgetu.
    function form($instance) {
        $defaults = array( 
			'title' => 'Wiadomości RSS', 
			'rss_feed' => 'http://strangework.com/feed', 
			'rss_items' => '2' 
		); 
        $instance = wp_parse_args( (array) $instance, $defaults );
        $title = $instance['title'];
        $rss_feed = $instance['rss_feed'];
        $rss_items = $instance['rss_items'];
		$rss_date = $instance['rss_date'];
		$rss_summary = $instance['rss_summary'];
        ?>
            <p>Tytuł: <input class="widefat" name="<?php echo $this->get_field_name( 'title' ); ?>"  type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
            <p>Wiadomość RSS: <input class="widefat" name="<?php echo $this->get_field_name( 'rss_feed' ); ?>"  type="text" value="<?php echo esc_attr( $rss_feed ); ?>" /></p>
            <p>Elementy do wyświetlenia:
            	<select name="<?php echo $this->get_field_name( 'rss_items' ); ?>">
                    <option value="1" <?php selected( $rss_items, 1 ); ?>>1</option>
                    <option value="2" <?php selected( $rss_items, 2 ); ?>>2</option>
                    <option value="3" <?php selected( $rss_items, 3 ); ?>>3</option>
                    <option value="4" <?php selected( $rss_items, 4 ); ?>>4</option>
                    <option value="5" <?php selected( $rss_items, 5 ); ?>>5</option>
                </select>
            </p>
            <p>Wyświetlić datę?: <input name="<?php echo $this->get_field_name( 'rss_date' ); ?>"  type="checkbox" <?php checked( $rss_date, 'on' ); ?> /></p>
            <p>Wyświetlić podsumowanie?: <input name="<?php echo $this->get_field_name( 'rss_summary' ); ?>"  type="checkbox" <?php checked( $rss_summary, 'on' ); ?> /></p>
        <?php
    }
 
    // Zapis ustawień widgetu.
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['rss_feed'] = strip_tags( $new_instance['rss_feed'] );
        $instance['rss_items'] = strip_tags( $new_instance['rss_items'] );
	$instance['rss_date'] = strip_tags( $new_instance['rss_date'] );
	$instance['rss_summary'] = strip_tags( $new_instance['rss_summary'] );
 
        return $instance;
    }
 
    // Wyświetlenie widgetu.
    function widget($args, $instance) {
        extract($args);
 
        echo $before_widget;
		
		// Wczytanie ustawień widgetu.
        $title = apply_filters( 'widget_title', $instance['title'] );
        $rss_feed = empty( $instance['rss_feed'] ) ? '' : $instance['rss_feed'];
        $rss_items = empty( $instance['rss_items'] ) ? 2 : $instance['rss_items'];
		$rss_date = empty( $instance['rss_date'] ) ? 0 : 1; 
		$rss_summary = empty( $instance['rss_summary'] ) ? 0 : 1; 
 
        if ( !empty( $title ) ) { echo $before_title . $title . $after_title; };

		if ( $rss_feed ) {
			// Wyświetlenie wiadomości RSS.
			wp_widget_rss_output( array(
				'url' => $rss_feed,
				'title' => $title,
				'items' => $rss_items,
				'show_summary' => $rss_summary,
				'show_author' => 0,
				'show_date' => $rss_date
			) );
		}

        echo $after_widget;
    }
}
?>
