<?php

add_filter( 'single_template', 'boj_single_template' );

function boj_single_template( $template ) {
    global $wp_query;

    /* Sprawdzenie czy wywietlany jest pojedynczy wpis bloga. */
    if ( is_singular( 'post' ) ) {
						
				/* Pobranie identyfikatora wpisu bloga. */
        $post_id = $wp_query->get_queried_object_id();
				
				/* Pobranie kategorii wpisu bloga. */
        $terms = get_the_terms( $post_id, 'category' );
				
				/* Iteracja przez kategorie i ich dodanie jako czci nazwy pliku. */
        $templates = array();
        foreach ( $terms as $term )
            $templates[] = "single-category-{$term->slug}.php";
				
				/* Sprawdzenie czy szablon istnieje. */
        $locate = locate_template( $templates );
				
				/* Jeeli szablon zosta znaleziony, wwczas bdzie uyty. */
        if ( !empty( $locate ) )
            $template = $locate;
		}

    /* Zwrot nazwy pliku szablonu. */    
    return $template;
}

?>
