<?php 
/*
Plugin Name: Przykład wtyczki przełączającej witryny sieci Multisite
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka demonstrująca przełączanie witryn w sieci Multisite
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'admin_menu', 'boj_multisite_switch_menu' );

function boj_multisite_switch_menu() {

	// Utworzenie własnego menu najwyższego poziomu.
	add_menu_page( 'Przełącznik witryn w sieci Multisite', 'Przełącznik witryn w sieci Multisite', 'manage_options', 'boj-network-switch', 'boj_multisite_switch_page' );

}
	
function boj_multisite_switch_page() {
	
	if ( is_multisite() ) {
		
		// Przejście do bloga o identyfikatorze 3.
		switch_to_blog( 3 );

		// Utworzenie własnej pętli.
		$recentPosts = new WP_Query();
		$recentPosts->query( 'posts_per_page=5' );
		
		// Rozpoczęcie wykonywania pętli.
		while ( $recentPosts->have_posts() ) : $recentPosts->the_post();
		
			// Przechowywanie ostatnich wpisów bloga w zmiennej.
			echo '<p><a href="' .get_permalink(). '">' .get_the_title() .'</a></p>';
			
		endwhile;
		
		// Przywrócenie bieżącej witryny.
		restore_current_blog();
		
	}
	
}
?>
