<?php 
/*
Plugin Name: Przykładowa wtyczka używająca cron
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka demonstrująca użycie cron na platformie WordPress.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'admin_menu', 'boj_cron_menu' );

function boj_cron_menu() {

	// Utworzenie przykładowej strony ustawień.
    add_options_page( 'Przykład ustawień Cron', 'Ustawienia Cron', 'manage_options', 'boj-cron', 'boj_cron_settings' );
	
}

add_action('boj_cron_hook', 'boj_cron_email_reminder');

function boj_cron_email_reminder() {

	// Wysłanie wiadomości e-mail.
	wp_mail( 'ty@przyklad.pl', 'Przypomnienie', 'Tylko nie zasypiaj!' );
	
}

function boj_cron_settings() {

	// Upewnienie się, że zadanie nie zostało wcześniej umieszczone w harmonogramie.
	if ( !wp_next_scheduled( 'boj_cron_hook' ) ) {
	
		// Określenie, że zadanie będzie wywoływane co godzinę.
		wp_schedule_event( time(), 'hourly', 'boj_cron_hook' );
		
	}

}
?>
