<?php
/*
Plugin Name: Ocena użytkownika
Plugin URI: http://przyklad.pl
Description: Wtyczka uaktualnia ocenę użytkownika na podstawie liczby opublikowanych wpisów bloga.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/
/* Uaktualnienie oceny użytkownika następuje wyłącznie podczas zapisu wpisu bloga.. */
add_action( 'save_post', 'boj_add_user_rating' );
function boj_add_user_rating() {
    /* Pobranie bieżącego użytkownika. */
    $user = wp_get_current_user();
    /* Pobranie bieżącej oceny użytkownika. */
    $rating = get_user_meta( $user->ID, 'user_rating', true );
    /* Jeżeli użytkownik ma już ocenę 'złoty', wówczas nie ulega ona zmianie. */
    if ( 'złoty' == $rating )
        return;
    /* Obliczenie liczby wpisów bloga opublikowanych przez użytkownika. */
    $posts = count_user_posts( $user->ID );
    /* Sprawdzenie, czy liczba opublikowanych wpisów bloga jest większa niż 50. */
    if ( 50 < = $posts ) {
        /* Przyznanie użytkownikowi oceny 'złoty'. */
        update_user_meta( $user->ID, 'user_rating', 'złoty' );
    }
    /* Sprawdzenie, czy liczba opublikowanych wpisów bloga jest równa lub większa niż 25. */
    elseif ( 25 < = $posts ) {
        /* Przyznanie użytkownikowi oceny 'srebrny'. */
        update_user_meta( $user->ID, 'user_rating', 'srebrny' );
    }
}
?> 

