// Wymagana jest biblioteka mongoose.
const mongoose = require('mongoose');

// Zdefiniowanie schematu bazy danych notatek.
const noteSchema = new mongoose.Schema(
  {
    content: {
      type: String,
      required: true
    },
    author: {
      type: String,
      required: true
    }
  },
  {
    // Przypisanie właściwości createdAt i updatedAt typu Date.
    timestamps: true
  }
);

// Zdefiniowanie modelu Note wraz ze schematem.
const Note = mongoose.model('Note', noteSchema);
// Eksport modułu.
module.exports = Note;
