module.exports = {
  notes: async (parent, args, { models }) => {
    return await models.Note.find().limit(100);
  },
  note: async (parent, args, { models }) => {
    return await models.Note.findById(args.id);
  },
  user: async (parent, args, { models }) => {
    return await models.User.findOne({ username: args.username });
  },
  users: async (parent, args, { models }) => {
    return await models.User.find({}).limit(100);
  },
  me: async (parent, args, { models, user }) => {
    return await models.User.findById(user.id);
  },
  noteFeed: async (parent, { cursor }, { models }) => {
    // Na stałe zdefiniowane ograniczenie do 10 elementów.
    const limit = 10;
    // Zdefiniowanie wartości domyślnej false dla hasNextPage.
    let hasNextPage = false;
    // Jeżeli kursor nie został przekazany, domyślne zapytanie będzie puste.
    // To spowoduje pobranie najnowszych notatek z bazy danych.
    let cursorQuery = {};

    // Jeżeli kursor został przekazany, zapytanie będzie szukało notatek,
    // których wartość ObjectId jest mniejsza niż kursora.
    if (cursor) {
      cursorQuery = { _id: { $lt: cursor } };
    }

    // Wyszukanie w bazie danych limit + 1 notatek, posortowanych od najnowszej do najstarszej.
    let notes = await models.Note.find(cursorQuery)
      .sort({ _id: -1 })
      .limit(limit + 1);

    // Jeżeli liczba znalezionych notatek przekracza wartość graniczną,
    // wówczas wartością hasNextPage będzie true i nadmierne notatki zostaną odrzucone.
    if (notes.length > limit) {
      hasNextPage = true;
      notes = notes.slice(0, -1);
    }

    // Nowy kursor będzie miał wartość identyfikatora obiektu MongoDV ostateniego elementu w tablicy kanału notatek.
    const newCursor = notes[notes.length - 1]._id;

    return {
      notes,
      cursor: newCursor,
      hasNextPage
    };
  }
};
