import '@testing-library/cypress/add-commands';
import { request, GraphQLClient } from 'graphql-request';
import { userBuilder } from './generate';

// Polecenie createUser.
Cypress.Commands.add('createUser', overrides => {
  // Mutacja graphql.
  const SIGNUP_USER = `
  mutation signUp($email: String!, $username: String!, $password: String!) {
    signUp(email: $email, username: $username, password: $password)
  }
  `;

  // Utworzenie nowego użytkownika i wylogowanie.
  const user = userBuilder();

  // Wykonanie mutacji GQL w celu utworzenia nowego użytkownika.
  return request('http://localhost:4000/api', SIGNUP_USER, {
    email: user.email,
    username: user.username,
    password: user.password
  }).then(data => {
    return { data, user };
  });
});

Cypress.Commands.add('loginUser', overrides => {
  // Mutacja graphql.
  const SIGNIN_USER = `
  mutation signIn($email: String!, $password: String!) {
    signIn(email: $email, password: $password)
  }
  `;

  // Utworzenie nowego użytkownika.
  cy.createUser().then(({ user }) => {
    // Wykonanie mutacji GQL w celu zalogowania.
    return request('http://localhost:4000/api', SIGNIN_USER, {
      email: user.email,
      password: user.password
    }).then(data => {
      window.localStorage.setItem('token', data.signIn);
      return { data, user };
    });
  });
});

Cypress.Commands.add('createNote', overrides => {
  // Mutacja graphql.
  // Zapytanie tworzące nową notatkę.
  const NEW_NOTE = `
    mutation newNote($content: String!) {
      newNote(content: $content) {
        id
        content
        createdAt
        favoriteCount
        favoritedBy {
          id
          username
        }
        author {
          username
          id
        }
      }
    }
  `;

  // Utworzenie nowego użytkownika.
  cy.createUser().then(({ data, user }) => {
    // Przechowywanie tokena JWT w magazynie danych localStorage.
    window.localStorage.setItem('token', data.signIn);

    // Utworzenie nowego klienta GraphQL z tokenem jako nagłówkiem.
    const client = new GraphQLClient('my-endpoint', {
      headers: {
        Authorization: data.signIn
      }
    });
    // Wykonanie mutacji GQL w celu logowania.
    return client
      .request('http://localhost:4000/api', NEW_NOTE, {
        content: 'Test note'
      })
      .then(data => {
        return data;
      });
  });
});
