const express = require('express');
const { ApolloServer, gql } = require('apollo-server-express');

// Uruchomienie serwera nasłuchującego na porcie wskazanym w pliku .env, czyli na porcie 4000.
const port = process.env.PORT || 4000;

let notes = [
  {
    id: '1',
    content: 'To jest notatka',
    author: 'Adam Scott'
  },
  {
    id: '2',
    content: 'Oto następna notatka',
    author: 'Harlow Everly'
  },
  {
    id: '3',
    content: 'Spójrz, to jest kolejna notatka!',
    author: 'Riley Harrison'
  }
];

// Utworzenie schematu za pomocą języka schematu GraphQL.
const typeDefs = gql`
  type Note {
    id: ID
    content: String
    author: String
  }

  type Query {
    hello: String
    notes: [Note]
    note(id: ID): Note
  }

  type Mutation {
    newNote(content: String!): Note
  }
`;

// Dostarczenie funkcji resolvera dla właściwości schematu.
const resolvers = {
  Query: {
    hello: () => 'Witaj, świecie!',
    notes: () => notes,
    note: (parent, args) => {
      return notes.find(note => note.id === args.id);
    }
  },
  Mutation: {
    newNote: (parent, args) => {
      let noteValue = {
        id: String(notes.length + 1),
        content: args.content,
        author: 'Adam Scott'
      };
      notes.push(noteValue);
      return noteValue;
    }
  }
};

const app = express();

// Konfiguracja serwera Apollo.
const server = new ApolloServer({ typeDefs, resolvers });

// Zastosowanie oprogramowania pośredniczącego Apollo GraphQL i zdefiniowanie ścieżki dostępu do /api.
server.applyMiddleware({ app, path: '/api' });

app.listen({ port }, () =>
  console.log(
    `Serwer GraphQL działa pod adresem http://localhost:${port}${server.graphqlPath}`
  )
);
