import React from 'react';
import { View, Button, Text } from 'react-native';
import * as SecureStore from 'expo-secure-store';
import { useMutation, gql } from '@apollo/client';

import UserForm from '../components/UserForm';
import Loading from '../components/Loading';

const SIGNIN_USER = gql`
  mutation signIn($email: String, $password: String!) {
    signIn(email: $email, password: $password)
  }
`;

const SignIn = props => {
  const [signIn, { loading, error }] = useMutation(SIGNIN_USER, {
    onCompleted: data => {
      // Przechowywanie tokena z kluczem o wartości 'token'.
      // Po zapisaniu tokena, należy przenieść użytkownika do ekranu głównego aplikacji.
      SecureStore.setItemAsync('token', data.signIn).then(
        props.navigation.navigate('App')
      );
    }
  });

  // Jeżeli dane są wczytywane, trzeba o tym poinformować użytkownika.
  if (loading) return <Loading />;
  return (
    <React.Fragment>
      {error && <Text>Błąd podczas uwierzytelniania!</Text>}
      <UserForm
        action={signIn}
        formType="signIn"
        navigation={props.navigation}
      />
    </React.Fragment>
  );
};

SignIn.navigationOptions = {
  title: 'Logowanie'
};

export default SignIn;
