import React from 'react';
import { Text, View } from 'react-native';
import { useQuery, gql } from '@apollo/client';

import NoteFeed from '../components/NoteFeed';
import Loading from '../components/Loading';

// Nasze zapytanie GraphQL.
const GET_MY_NOTES = gql`
  query me {
    me {
      id
      username
      notes {
        id
        createdAt
        content
        favoriteCount
        author {
          username
          id
          avatar
        }
      }
    }
  }
`;

const MyNotes = props => {
  const { loading, error, data } = useQuery(GET_MY_NOTES);

  // Jeżeli dane są wczytywane, należy wyświetlić odpowiedni komunikat.
  if (loading) return <Loading />;
  // Jeżeli podczas pobierania danych wystąpi błąd, należy wyświetlić komunikat błędu.
  if (error) return <Text>Błąd podczas pobierania notatek.</Text>;
  // Jeżeli wykonanie zapytania zakończyło się sukcesem i są notatki, należy zwrócić kanał notatek.
  // Natomiast jeżeli wykonanie zapytania zakończyło się sukcesem, ale nie ma notatek, należy wyświetlić odpowiedni komunikat.
  if (data.me.notes.length !== 0) {
    return <NoteFeed notes={data.me.notes} navigation={props.navigation} />;
  } else {
    return <Text>Nie ma jeszcze żadnych notatek.</Text>;
  }
};

MyNotes.navigationOptions = {
  title: 'Moje notatki'
};

export default MyNotes;
