/* Plik pomocniczy przeznaczony dla programistycznego środowiska testowego lub lokalnego.
/* Generuje 25 przykładowych notatek. */

const faker = require('faker');
const mongoose = require('mongoose');
const fetch = require('node-fetch');

const seedNotes = async users => {
  console.log('Seeding notes...');
  let notes = [];

  // Generowanie notatek.
  for (var i = 0; i < 25; i++) {
    // Pobranie losowo wybranego użytkownika z tablicy.
    let random = [Math.floor(Math.random() * users.length)];
    let content;

    // Pobranie treści z API lorem markdownum.
    const response = await fetch(
      'https://jaspervdj.be/lorem-markdownum/markdown.txt'
    );

    // Jeżeli odpowiedzią jest ok, użyta będzie treść. W przeciwnym razie treść zostanie wygenerowana, w postaci akapitu ipsum.
    if (response.ok) {
      content = await response.text();
    } else {
      content = faker.lorem.paragraph();
    }

    let note = {
      content,
      favoriteCount: 0,
      favoritedBy: [],
      author: mongoose.Types.ObjectId(users[random]._id)
    };
    notes.push(note);
  }
  return notes;
};

module.exports = seedNotes;
