package{
	import flash.display.Sprite;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	
	public class TrigAnimations extends Sprite{
		
		private var ball:Ball;
		private var ball1:Ball;		
		private var xA:Array=new Array();
		private var yA:Array=new Array();
		private var timer:Timer;		
		private var n:int=0;
		private var xmin=0;
		private var xmax=1440;		
		private var ymin=-1;
		private var ymax=1;		
		private var xorig=50;
		private var yorig=200;
		private var xwidth=400;
		private var ywidth=300;		
		private var xscal;
		private var yscal;
		
		public function TrigAnimations(){
			init();
		}
		private function init():void{
			plotGraph();
			placeBall();
			setupTimer();
		}
		private function plotGraph():void{
			var graph:Graph = new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);			
			graph.drawgrid(180,45,0.5,0.1);			
			graph.drawaxes('x','y');	
			addChild(graph);
			xscal=(xmax-xmin)/xwidth;
			yscal=(ymax-ymin)/ywidth;
			for (var i:uint=0; i<=200; i++){
				xA[i] = i*7.2;
				yA[i] = f(xA[i]);						   
			}
			graph.plot(xA,yA,0xff0000,false,true);			
		}
		private function f(x:Number):Number{
			var y:Number;
			//y = Math.sin(x*Math.PI/180);
			//y = Math.sin(x*Math.PI/180)*Math.exp(-0.002*x);
			//y = Math.sin(x*Math.PI/180) + Math.sin(1.5*x*Math.PI/180);
			//y = 0.5*Math.sin(3*x*Math.PI/180) + 0.5*Math.sin(3.5*x*Math.PI/180);			
			//y = 0.2*Math.sin(x*Math.PI/180) + 0.4*Math.sin(2*x*Math.PI/180) + 0.6*Math.sin(3*x*Math.PI/180);
			//y = Math.sin(x*Math.PI/180) + Math.sin(3*x*Math.PI/180)/3;
			// y = Math.sin(x*Math.PI/180) + Math.sin(3*x*Math.PI/180)/3 + Math.sin(5*x*Math.PI/180)/5;
			//y = Math.sin(x*Math.PI/180) + Math.sin(3*x*Math.PI/180)/3 + Math.sin(5*x*Math.PI/180)/5 + Math.sin(7*x*Math.PI/180)/7;			
			y = fourierSum(10,x);
			//y = fourierSum(1000,x);
			return y;
		}
		private function fourierSum(N:int,x:Number):Number{
			var fs:Number=0;
			for (var nn:uint=1; nn<=N; nn=nn+2){
				fs += Math.sin(nn*x*Math.PI/180)/nn;
			}
			return fs;
		}		
		private function placeBall():void{
			ball = new Ball(6);
			ball.x = xA[0]/xscal+ xorig;
			ball.y = -yA[0]/yscal + yorig;
			addChild(ball);	
			// dodaje nową instancję klasy ball
			ball1 = new Ball(6);
			ball1.x = ball.x + 450;
			ball1.y = ball.y;
			addChild(ball1);				
		}
		private function setupTimer():void{
			timer = new Timer(20);
			timer.addEventListener(TimerEvent.TIMER,moveBall);		
			timer.start();
		}		
		private function moveBall(evt:TimerEvent):void{
			ball.x = xA[n]/xscal + xorig;
			ball.y = -yA[n]/yscal + yorig;
			ball1.y = ball.y;			
			evt.updateAfterEvent();			
			n++;
			if (n==xA.length){
				timer.stop();
				timer.removeEventListener(TimerEvent.TIMER,moveBall);				
			}
		}
	}
}