package {
	import flash.display.Sprite;
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Ball;	
	import com.physicscodes.math.Vector2D;

	public class ParticleEmitter extends MultiForcer{

		private var _sprite:Sprite;
		private var _particles:Array = new Array();
		private var _maxParticles:uint = 120;		
		private var _g:Number = 20;
		private var _k:Number = 0.003;
		private var _vx:Number = 60;
		private var _vy:Number = -80;
		private var _i:int=0;
		
		public function ParticleEmitter(psprite:Sprite):void{		
			_sprite = psprite;
			super(_particles);
		}	
		
		override protected function calcForce(pparticle:Particle):void{
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);	
			var drag:Vector2D = Forces.drag(_k,pparticle.velo2D);
			force = Forces.add([gravity, drag]);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			createNewParticles(new Vector2D(_sprite.mouseX,_sprite.mouseY));
			limitParticles();
		}		
		
		private function createNewParticles(ppos:Vector2D):void{
			var newBall:Ball = new Ball(2);
			newBall.pos2D = ppos;
			newBall.velo2D = new Vector2D((Math.random()-0.5)*_vx,(Math.random()+0.5)*_vy);		
			
			var n:int; 
			n = _i%7;
			var angle:Number = -(60+10*n)*Math.PI/180;
			var mag:Number = 100;
			newBall.velo2D = Vector2D.vector2D(mag,angle);
			_i++;		
			
			_sprite.addChild(newBall);
			_particles.push(newBall);
		}		
		
		private function limitParticles():void{
			if (_particles.length > _maxParticles){
				_sprite.removeChild(_particles[0]);
				_particles.shift();
			}
		}		
		
	}
}
