package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;
	
	public class ForcedOscillator extends Forcer{
		private var _object:Ball;
		private var _center:Vector2D;
		private var _graph:Graph;
		private var _displ:Vector2D;
		private var _kSpring:Number=10;
		private var _cDamping:Number=0.5;		
		private var _gamma:Number;
		private var _omega0:Number;
		private var _omegad:Number;

		public function ForcedOscillator(pobject:Ball,pattractor:Ball):void{
			_object = pobject;
            _center = pattractor.pos2D;
			_gamma = 0.5*_cDamping/Math.sqrt(_kSpring*_object.mass);
			_omega0 = Math.sqrt(_kSpring/_object.mass);
			_omegad = _omega0*Math.sqrt(1-_gamma*_gamma);
			setupGraph();
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();		
			plotGraph();
		}		
			
		override protected function calcForce():void{
            _displ=_object.pos2D.subtract(_center);
			var restoring:Vector2D = Forces.spring(_kSpring,_displ);
			var damping:Vector2D = Forces.damping(_cDamping,_object.velo2D);		
			var forcing:Vector2D = new Vector2D(200*Math.cos(2*_omegad*time)+200*Math.sin(2*_omegad*time),0);
			//var forcing:Vector2D = new Vector2D(200*Math.cos(_omegad*time/2)+200*Math.sin(_omegad*time/2),0);
			//var forcing:Vector2D = new Vector2D(200*Math.cos(_omegad*time)+200*Math.sin(_omegad*time),0);
			//var forcing:Vector2D = new Vector2D(1000*Math.random(),0);			
			//var forcing:Vector2D = new Vector2D(1000*(Math.random()-0.5),0);
			//var forcing:Vector2D = new Vector2D(1000*(Math.random()-0.5),1000*(Math.random()-0.5));
			force = Forces.add([restoring, damping, forcing]);
		}
		
		// tworzy wykres zależności przemieszczenia od czasu		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,20,-250,250,50,250,450,200);					
			_graph.drawgrid(5,1,50,50);			
			_graph.drawaxes('time (s)','displacement (px)');		
			_object.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([time], [_displ.x], 0xff0000, false, true);
			_graph.plot([time], [_displ.y], 0x0000ff, false, true);			
		}	
	}
}