﻿package com.physicscodes.objects {
	import flash.display.Sprite;	
	import com.physicscodes.math.Vector2D;	
	
	public class PolygonRB extends RigidBody{
		private var _vertices:Array; // note that vertices shall be defined in an anticlockwise sense	
		private var _sides:Array;		
		private var _color:uint;
		private var _sprite:Sprite;		

		public function PolygonRB(pvertices:Array,pcm:Vector2D,pcolor:uint=0x000000,pim:Number=1,pmass:Number=1,pcharge:Number=0){
			this.centerOfMass = pcm;
			this.momentOfInertia = pim;
			this.mass = pmass;
			this.charge = pcharge;		
			_vertices = pvertices; 
			_color = pcolor;
			_sprite = new Sprite();			
			defineSides();
			drawPolygon();
			super(pcm,pim,pmass,pcharge);
		}
		
		private function defineSides():void{
			_sides=new Array();
			var side:Vector2D;
			for(var i:uint=0; i<_vertices.length-1; i++){
				side = _vertices[i+1].subtract(_vertices[i]);
				_sides.push(side);
			}
			side = _vertices[0].subtract(_vertices[i]);
			_sides.push(side);			
		}

		private function drawPolygon():void{
			with (_sprite.graphics){	
				//lineStyle(1,_color);
				beginFill(color);
				moveTo(_vertices[0].x,_vertices[0].y);
				for (var i:uint=1; i<_vertices.length; i++){
					lineTo(_vertices[i].x,_vertices[i].y);
				}
				lineTo(_vertices[0].x,_vertices[0].y);			
				endFill();
				/*
				moveTo(_vertices[0].x+centerOfMass.x,_vertices[0].y+centerOfMass.y);
				for (var i:uint=1; i<_vertices.length; i++){
					lineTo(_vertices[i].x+centerOfMass.x,_vertices[i].y+centerOfMass.y);
				}
				lineTo(_vertices[0].x+centerOfMass.x,_vertices[0].y+centerOfMass.y);				
				*/
			}
			addChild(_sprite);
		}		
				
		public function clear():void{
			_sprite.graphics.clear();
			removeChild(_sprite);
		}
		
		public function get color():Number{
			return _color;
		}
		
		public function set color(pcolor:Number):void{
			_color = pcolor;
			clear();
			drawPolygon();
		}
		
		public function get vertices():Array{
			return _vertices;
		}
		public function set vertices(pvertices:Array):void{
        	vertices=_vertices;
			defineSides();
			clear();
			drawPolygon();
		}	
		
		// returns the vertex furthest from the center of mass
		public function get maxVertex():Number{
			var _maxVertex:Number=0;
			for(var i:uint=1;i<_vertices.length;i++){
				if(_vertices[i].length>_maxVertex){
					_maxVertex=_vertices[i].length;
				}
			}
			return _maxVertex;
		}		
		
		public function get sides():Array{
			return _sides;
		}		
	
	}
	
}
