﻿package com.physicscodes.objects {
	import flash.display.Sprite;	
	import flash.geom.Matrix;	
	import flash.display.GradientType;
	
	// note this is visually a 2D object but has all the 3D properties of Particle3D
	public class Ball3D extends Particle3D{
		private var _radius:Number;
		private var _color:uint;
		private var _gradient:Boolean;		
		private var _sprite:Sprite;		

		public function Ball3D(pradius:Number=20,pcolor:uint=0x0000ff,pmass:Number=1,pcharge:Number=0,pgradient:Boolean=true){
			this.mass=pmass;
			this.charge=pcharge;			
			_radius=pradius;
			_color=pcolor;
			_gradient = pgradient;			
			_sprite = new Sprite();			
			drawBall();
		}

		private function drawBall():void{
			with (_sprite.graphics){	
				if (_gradient){
					var matrix:Matrix = new Matrix();
					matrix.createGradientBox(_radius,_radius,0,-_radius,-_radius/2);					
					beginGradientFill(GradientType.RADIAL,[0xffffff,_color],[1,1],[0,255],matrix);
				}else{
					beginFill(_color);
				}
				drawCircle(0,0,_radius);
				endFill();
			}
			addChild(_sprite);
		}		
		
		public function clone():Ball3D{
			return new Ball3D(radius,color,mass,charge,gradient);			
		}
		
		public function clear():void{
			_sprite.graphics.clear();
			removeChild(_sprite);
		}

		public function get radius():Number{
			return _radius;
		}
		
		public function set radius(pradius:Number):void{
			_radius = pradius;
			clear();
			drawBall();
		}
		
		public function get color():Number{
			return _color;
		}
		
		public function set color(pcolor:Number):void{
			_color = pcolor;
			clear();
			drawBall();
		}
		
		public function get gradient():Boolean{
			return _gradient;
		}
		
		public function set gradient(pgradient:Boolean):void{
			_gradient = pgradient;
			clear();
			drawBall();
		}		
		
	}
	
}
