package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import flash.events.MouseEvent;	

	public class Floater extends Forcer{
		private var _particle:Particle;		
		private var _g:Number=10;
		private var _rho:Number=1.5;
		private var _V:Number=1;
		private var _k:Number=0.01;
		private var _yLevel:Number=100;

		public function Floater(pparticle:Particle):void{
			_particle = pparticle;		
			_particle.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
			super(pparticle);
		}	

		override protected function calcForce():void{
			var rball:Number=0.5*_particle.height;
			var yball:Number=_particle.y;
			var dr:Number= (yball-_yLevel)/rball;
			var ratio:Number; // fragment objętości ciała zanurzonej w płynie
			if (dr <= -1){ // gdy ciało znajduje się w całości poza wodą
				ratio=0;
			}else if (dr < 1){ // gdy ciało znajduje się częściowo w wodzie 			
				//ratio = 0.5 + 0.5*dr; // dla sześcianu
				ratio = 0.5 + 0.25*dr*(3-dr*dr); // dla kuli
			}else{ // gdy ciało jest całkowicie zanurzone
				ratio=1;
			}
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var upthrust:Vector2D = Forces.upthrust(_rho,_V*ratio,_g);
			var drag:Vector2D = Forces.drag(_k*ratio,_particle.velo2D);
			force = Forces.add([gravity, upthrust, drag]);	
		}
		
		private function onDown(e:MouseEvent):void{
			_particle.velo2D = new Vector2D(0,0);
			_particle.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_particle.startDrag(true);
			stopTime();			
		}
		private function onUp(e:MouseEvent):void{
			_particle.pos2D = new Vector2D(_particle.x,_particle.y);
			_particle.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_particle.stopDrag();
			startTime(10);			
		}
	}
}
