package {
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class BubbleWindMover extends MultiForcer{
		
		private var _particles:Array;		
		private var _g:Number=10;
		private var _rho:Number=1;
		private var _rhoP:Number=0.99;
		private var _kfac:Number=0.01;
		private var _windvel:Vector2D = new Vector2D(40,0);

		public function BubbleWindMover(pparticles:Array):void{
			_particles = pparticles;	
			super(pparticles);
		}			

		override protected function calcForce(pparticle:Particle):void{
			var V:Number = pparticle.mass/_rhoP;
			var k:Number = pparticle.width*pparticle.width*_kfac;
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);
			var upthrust:Vector2D = Forces.upthrust(_rho,V,_g);
			var relwind:Vector2D = _windvel.subtract(pparticle.velo2D);
			var wind:Vector2D = Forces.drag(-k,relwind);	
			force = Forces.add([gravity, upthrust, wind]);								
		}
	}
}
