package {
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Particle;	
	import com.physicscodes.math.Vector2D;
	import flash.display.Sprite;
	import flash.events.MouseEvent;	
	
	public class ClothMover extends MultiForcer2{
		private var _objects:Array;
		private var _displ:Vector2D;
		private var _g:Number=10;
		private var _kDamping:Number=10;
		private var _kSpring:Number=100;
		private var _kWind:Number=10;
		private var _springLength:Number=20;
		private var _windMag:Number=10;		
		private var _w:Number=0;
		private var _fixedPoints:Array;		
		private var _nrows:uint;
		private var _ncols:uint;		
		private var _spring:Sprite;
		
		public function ClothMover(pobjects:Array,pfixedPoints,pcols:uint,prows:uint,pspring:Sprite):void{
			_objects = pobjects;
			_fixedPoints = pfixedPoints;
			_ncols = pcols;
			_nrows = prows;			
			_spring = pspring;
			_spring.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);							
			super(_objects);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			drawSpring();			
		}		
		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			// zmienne przechowujące położenia i prędkości najbliższych sąsiadów
			var centerUp:Vector2D;
			var centerDown:Vector2D;
			var centerLeft:Vector2D;
			var centerRight:Vector2D;
			var veloUp:Vector2D;
			var veloDown:Vector2D;
			var veloLeft:Vector2D;
			var veloRight:Vector2D;			
			
			// położenie i prędkość cząstki znajdującej się dokładnie nad cząstką, dla której prowadzone są obliczenia			
			if ((pnum-Math.floor(pnum/_nrows)*_nrows) > 0){
				centerUp = _objects[pnum-1].pos2D;
				veloUp = _objects[pnum-1].velo2D;				
			}else{ // gdy cząstka jest pierwsza w rzędzie i nie ma innej nad sobą, użyj jej położenia i prędkości 
				centerUp= pparticle.pos2D;
				veloUp= pparticle.velo2D;				
			}
			// położenie i prędkość cząstki znajdującej się dokładnie pod cząstką, dla której prowadzone są obliczenia						
			if ( ((pnum+1)-Math.floor( (pnum+1)/_nrows) * _nrows) > 0){
				centerDown = _objects[pnum+1].pos2D;
				veloDown = _objects[pnum+1].velo2D;				
			}else{ // gdy cząstka jest ostatnia w rzędzie i nie ma innej pod sobą, użyj jej położenia i prędkości
				centerDown= pparticle.pos2D;
				veloDown= pparticle.velo2D;				
			}
			// położenie i prędkość cząstki znajdującej się po lewej stronie cząstki, dla której prowadzone są obliczenia			
			if (pnum > (_nrows-1) ){
				centerLeft = _objects[pnum-_nrows].pos2D;
				veloLeft = _objects[pnum-_nrows].velo2D;
			}else{ // gdy cząstka jest pierwsza w kolumnie i nie ma po lewej innej, użyj jej położenia i prędkości 
				centerLeft= pparticle.pos2D;
				veloLeft= pparticle.velo2D;				
			}
			// położenie i prędkość cząstki znajdującej się po prawej stronie cząstki, dla której prowadzone są obliczenia			
			if (pnum < _nrows*(_ncols -1) ) {
				centerRight = _objects[pnum+_nrows].pos2D;
				veloRight = _objects[pnum+_nrows].velo2D;
			}else{  // gdy cząstka jest ostatnia w kolumnie i nie ma po prawej innej, użyj jej położenia i prędkości
				centerRight= pparticle.pos2D;
				veloRight= pparticle.velo2D;
			}
			
			// uwzględnij siłę grawitacji działającą na cząski, które nia są nieruchome
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);
//			var damping:Vector2D = Forces.damping(_kDamping,pparticle.velo2D);			
			// tłumienie 
			var velo:Vector2D = pparticle.velo2D.multiply(4).subtract(veloUp).subtract(veloDown).subtract(veloLeft).subtract(veloRight);
			var damping:Vector2D = Forces.damping(_kDamping,velo);				
			// wektor przemieszczenia bieżącej cząstki od jej najbliższych sąsiadów
			var displUp:Vector2D = pparticle.pos2D.subtract(centerUp);
			var displDown:Vector2D = pparticle.pos2D.subtract(centerDown);			
			var displLeft:Vector2D = pparticle.pos2D.subtract(centerLeft);
			var displRight:Vector2D = pparticle.pos2D.subtract(centerRight);			
			// wektor wyhylenia ciała z równowagi z uwzględnieniem wpływu najbliższych sąsiadów
			var extensionUp:Vector2D = displUp.subtract(displUp.unit().multiply(_springLength));
			var extensionDown:Vector2D = displDown.subtract(displDown.unit().multiply(_springLength));	
			var extensionLeft:Vector2D = displLeft.subtract(displLeft.unit().multiply(_springLength));
			var extensionRight:Vector2D = displRight.subtract(displRight.unit().multiply(_springLength));	
			// siła sprężystości od najbliższych sąsiadów
			var restoringUp:Vector2D = Forces.spring(_kSpring,extensionUp);
			var restoringDown:Vector2D = Forces.spring(_kSpring,extensionDown);									
			var restoringLeft:Vector2D = Forces.spring(_kSpring,extensionLeft);
			var restoringRight:Vector2D = Forces.spring(_kSpring,extensionRight);									
			// prędkość wiatru i związana z nią siła
			var windVelocity:Vector2D = new Vector2D(_w,0);
			var windForce:Vector2D = Forces.linearDrag((-1)*_kWind,windVelocity.subtract(pparticle.velo2D));
			// określa, które cząski nie przemieszczają się
			var fixed:Boolean = false;
			for (var i:uint=0; i<_fixedPoints.length; i++){
				if (pnum==_fixedPoints[i]){
					fixed = true;
				}
			}
			// działa siłami na cząski, których położenie nie jest ustalone
			if (!fixed){
 				force = Forces.add([gravity, damping, restoringUp, restoringDown,restoringLeft, restoringRight, windForce]);
			}else{ // na cząski, których położenie nie jest ustalone, działa zerowa siła
				force=new Vector2D(0,0);
			}
		}			
		
		// funkcja rysująca linie pomiędzy sąsiadującymi cząstkami
		private function drawSpring():void{
			with (_spring.graphics){
				clear();		
				lineStyle(2,0x009999);
				for (var i:uint=0; i<(_nrows*_ncols); i++){ 
					var X:Number = _objects[i].xpos;
					var Y:Number = _objects[i].ypos;
					if((i-Math.floor(i/_nrows)*_nrows) ==0) {
					moveTo(X,Y);
					}
					else{
					lineTo(X,Y);
					}
				}
				for (i=0; i<(_nrows); i++){
					X = _objects[i].xpos;
					Y = _objects[i].ypos;
					moveTo(X,Y);
					for (var j:uint=0; j<(_ncols); j++){
					X= _objects[i+j*_nrows].xpos;
					Y = _objects[i+j*_nrows].ypos;
					lineTo(X,Y);
					}
				}
			}
		}
		
		private function onDown(e:MouseEvent):void{
			_spring.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_w = _windMag;
		}
		private function onUp(e:MouseEvent):void{
			_spring.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_w = 0;
		}			
				
	}
}