﻿package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Ball;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;		

	public class Electro extends Forcer{
		
		private var _particle:Ball;			
		private var _particleCharge:Number;
		private var _E:Vector2D;
		private var _graph:Graph;		
		private var _stageWidth;
		private var _stageHeight;		

		public function Electro(pparticle:Ball):void{
			_particle = pparticle;
			_particleCharge = pparticle.charge;			
			_stageWidth = _particle.stage.stageWidth;			
			_stageHeight = _particle.stage.stageHeight;					
			setupGraph();
			super(pparticle);
		}	
		
		override protected function calcForce():void{
			//_E = new Vector2D(0,50*Math.cos(1*time));			
			//_E = new Vector2D(0,50*Math.cos(2*time));
			//_E = new Vector2D(0,50*Math.cos(3*time));			
			//_E = new Vector2D(1,50*Math.cos(1*time));
			_E = new Vector2D(1,2*time*Math.cos(1*time));
			//_E = new Vector2D(50*Math.cos(1*time),50*Math.cos(1*time));
			//_E = new Vector2D(20*Math.sin(1*time),20*Math.cos(1*time));
			//_E = new Vector2D(20*Math.sin(1*time-1),20*Math.cos(1*time));
			force = Forces.forceField(_particleCharge,_E);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();
		}

		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_particle.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_particle.xpos], [-_particle.ypos],0x666666, false, true);		
		}	
		
	}
}
