package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Attractor extends Forcer{
		
		private var _orbiter:Particle;			
		private var _attractors:Array;
		private var _massOrbiter:Number;
		private var _G:Number;

		public function Attractor(porbiter:Particle,pattractors:Array,pG:Number):void{
			_orbiter = porbiter;
			_attractors = pattractors;
			_massOrbiter = porbiter.mass;			
			_G = pG;
			super(porbiter);
		}	
		
		override protected function calcForce():void{
			var gravity:Vector2D;
			force = Forces.zeroForce();
			for (var i:uint=0; i<_attractors.length; i++){
				var attractor:Particle=_attractors[i];
				gravity = Forces.gravity(_G,attractor.mass,_massOrbiter,_orbiter.pos2D.subtract(attractor.pos2D));		
				force = Forces.add([force, gravity]);
			}
		}
	}
}
