package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import flash.events.MouseEvent;	

	public class Floater extends Forcer{
		private var _particle:Particle;		
		private var _g:Number=50;
		private var _rho:Number=1.5;
		private var _V:Number=1;
		private var _k:Number=0.01;
		private var _yLevel:Number=200;
		private var _xEdge:Number=300;
		private var _groundLevel:Number=150;
		private var _vfac:Number=-0.8;
		private var _stageWidth:Number=800;

		public function Floater(pparticle:Particle):void{
			_particle = pparticle;		
			_particle.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
			super(pparticle);
		}	

		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var rball:Number=0.5*_particle.height;
			var xball:Number=_particle.x;				
			var yball:Number=_particle.y;			
			var dr:Number= (yball-_yLevel)/rball;
			var ratio:Number; // fragment objętości ciała zanurzonej w płynie
			if (dr <= -1){ // gdy ciało znajduje się w całości poza wodą
				ratio=0;
			}else if (dr < 1){ // gdy ciało znajduje się częściowo w wodzie 			
				//ratio = 0.5 + 0.5*dr; // dla sześcianu
				ratio = 0.5 + 0.25*dr*(3-dr*dr); // dla kuli
			}else{ // gdy ciało jest całkowicie zanurzone
				ratio=1;
			}
			var upthrust:Vector2D = new Vector2D(0,-_rho*_V*ratio*_g);
			var drag:Vector2D = _particle.velo2D.multiply(-ratio*_k*_particle.velo2D.length);
			force = Forces.add([gravity, upthrust, drag]);	
			if (xball < rball){
				_particle.xpos = rball;
				_particle.vx *= _vfac;				
			}
			if (xball > _stageWidth - rball){
				_particle.xpos = _stageWidth - rball;
				_particle.vx *= _vfac;				
			}		
		}
		
		private function onDown(e:MouseEvent):void{
			_particle.velo2D = new Vector2D(0,0);
			_particle.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_particle.xpos = _particle.stage.mouseX;
			_particle.ypos = _particle.stage.mouseY;			
			stopTime();			
		}
		private function onUp(e:MouseEvent):void{
			//_particle.pos2D = new Vector2D(_particle.x,_particle.y);
			//_particle.velo2D = new Vector2D((Math.random()-0.5)*1000,(Math.random()-0.5)*1000);
			_particle.velo2D = new Vector2D(_particle.stage.mouseX-_particle.xpos,_particle.stage.mouseY-_particle.ypos);
			_particle.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			startTime();			
		}
	}
}
