﻿package com.physicscodes.objects {
	import flash.display.Sprite;	
	import com.physicscodes.math.Vector2D;	
	
	public class RectangleRB extends PolygonRB{
		private var _vertices:Array=new Array();	
		private var _rwidth:Number;
		private var _rheight:Number;

		public function RectangleRB(prwidth:Number,prheight:Number,pcm:Vector2D,pcolor:uint=0x000000,pim:Number=1,pmass:Number=1,pcharge:Number=0){
			this.centerOfMass = pcm;
			this.momentOfInertia = pim;
			this.mass = pmass;
			this.charge = pcharge;	
			_rwidth = prwidth;
			_rheight = prheight;
			getVertices();
			super(_vertices,pcm,pcolor,pim,pmass,pcharge);
		}

		private function getVertices():void{
			var vertex:Vector2D;
			vertex = new Vector2D(-_rwidth/2,-_rheight/2);
			_vertices.push(vertex);
			vertex = new Vector2D(_rwidth/2,-_rheight/2);
			_vertices.push(vertex);			
			vertex = new Vector2D(_rwidth/2,_rheight/2);
			_vertices.push(vertex);
			vertex = new Vector2D(-_rwidth/2,_rheight/2);
			_vertices.push(vertex);					
		}

	}
	
}
