﻿package com.physicscodes.objects{
	import flash.display.Sprite;
	import flash.geom.Vector3D;		
	import flash.geom.Point;
	import flash.geom.Matrix3D;

	public class PolyhedronRB extends RigidBody3D{
		private var _vertices:Vector.<Vector3D>;
		private var _faces:Vector.<Array>;
		private var _numVertices:int;
		private var _numFaces:int;			
		private var _facesColors:Array;
		private var _edgesColor:uint;
		private var _facesAlpha:Number;
		private var _edgesThickness:uint;
		private var _cm:Vector3D;	
		private var _fl:Number;		
		private var _sprite:Sprite;		
		private var _container:Sprite;

		public function PolyhedronRB(pfl:Number, pcm:Vector3D, pim:Vector3D,
									 pvertices:Vector.<Vector3D>, pfaces:Vector.<Array>,
									 pfacesColors:Array, pedgesColor:uint=0x000000,
									 pfacesAlpha:Number=0.8, pedgesThickness:uint=2,
									 pmass:Number=1, pcharge:Number=0){
			_fl=pfl;
			_cm = pcm;
			_vertices = pvertices;
			_faces = pfaces;
			_facesColors = pfacesColors;
			_edgesColor = pedgesColor;		
			_facesAlpha = pfacesAlpha;
			_edgesThickness = pedgesThickness;
			_numVertices = pvertices.length;
			_numFaces = pfaces.length;
			_sprite = new Sprite();
			_sprite.z = 0;
			_container = new Sprite();
			addChild(_container);
			updatePolyhedron(0,0,0);
			this.centerOfMass = pcm;
			this.Im = pim;
			this.mass = pmass;
			this.charge = pcharge;
			super(pcm,pim,pmass,pcharge);
		}

		public function get vertices():Vector.<Vector3D>{
			return _vertices;
		}
		public function set vertices(pvertices:Vector.<Vector3D>):void{
			vertices = _vertices;
			clear();
			drawPolyhedron();
		}
		
		public function clear():void{
			_container.graphics.clear();
		}

		public function updatePolyhedron(rotx:Number,roty:Number,rotz:Number):void{			
			// add incremental rotations to matrix3D property of _sprite
			_sprite.transform.matrix3D.appendRotation(rotx,Vector3D.X_AXIS);
			_sprite.transform.matrix3D.appendRotation(roty,Vector3D.Y_AXIS);
			_sprite.transform.matrix3D.appendRotation(rotz,Vector3D.Z_AXIS);						
			drawPolyhedron();					
		}

		// apply matrix3d transform and draw polyhedron in 3D using perspective projection and depth sorting
		private function drawPolyhedron():void{
			var i:int;
			var j:int;
			var newVertices:Vector.<Vector3D>=new Vector.<Vector3D>();
			var projVertices:Vector.<Point>=new Vector.<Point>();			
			var distArray:Array = new Array();
			var dist:Number;			
			var zAverage:Number;
			var currentFace:int;
			var currentFaceLen:int;

			//	transform vertices based on current matrix3D		
			for (i=0; i<_numVertices; i++){
				newVertices[i] = _sprite.transform.matrix3D.deltaTransformVector(_vertices[i]);
			}
			// apply perspective distortion
			for (i=0; i<_numVertices; i++){
				newVertices[i].w = (_fl + newVertices[i].z) / _fl;
				newVertices[i].project();
			}
			// depth sorting by distance
			for (i=0; i<_numFaces; i++){
				currentFaceLen = _faces[i].length;
				zAverage = 0;
				for (j=0; j<currentFaceLen; j++){
					zAverage +=  newVertices[_faces[i][j]].z;
				}
				zAverage /=  currentFaceLen;
				dist = zAverage;
				distArray[i] = [dist,i];
			}
			distArray.sort(byDist);
			// 2D points for drawing
			for (i=0; i<_numVertices; i++){
				projVertices[i] = new Point();
				projVertices[i].x = newVertices[i].x;
				projVertices[i].y = newVertices[i].y;
			}
			// draw object
			_container.graphics.clear();
			for (i=0; i<_numFaces; i++){
				currentFace = distArray[i][1];
				currentFaceLen = _faces[currentFace].length;
				with (_container.graphics){
					lineStyle(_edgesThickness,_edgesColor);				
					beginFill(_facesColors[currentFace],_facesAlpha);
					moveTo(projVertices[_faces[currentFace][0]].x,projVertices[_faces[currentFace][0]].y);
					for (j=1; j<currentFaceLen; j++){
						lineTo(projVertices[_faces[currentFace][j]].x,projVertices[_faces[currentFace][j]].y);
					}
					lineTo(projVertices[_faces[currentFace][0]].x,projVertices[_faces[currentFace][0]].y);
					endFill();
				}
			}
		}
		// function for depth sorting
		private function byDist(arr1:Array,arr2:Array):Number{
			if (arr1[0] > arr2[0]){
				return -1;
			}else if (arr1[0] < arr2[0]){
				return 1;
			}else{
				return 0;
			}
		}			

	}
}