package{
	import flash.display.Sprite;
	import com.physicscodes.math.Vector3DX;
	
	public class RK4Test3D extends Sprite{
		
		private var _dt:Number = 0.05;
		private var _numSteps:Number = 20;
		private var _t:Number = 0;
		private var _g:Number = 10;		
		private var _v:Vector3DX = new Vector3DX(0,0,0);			
		private var _s:Vector3DX = new Vector3DX(0,0,0);	
				
		public function RK4Test3D():void{
			init();
		}
		
		private function init():void{
			simulate();
		}
		private function simulate():void{
			trace(_t,_s.y);
			for (var i:uint=0; i<_numSteps; i++){
				_t += _dt; 				
				RK4();
				trace(_t,_s.y);
			}
		}
		private function RK4():void{			
			// krok 1
			var pos1:Vector3DX = _s;
			var vel1:Vector3DX = _v;
			var acc1:Vector3DX = getAcc(pos1,vel1); 
			// krok 2
			var pos2:Vector3DX = pos1.addScaled(vel1,_dt/2); 
			var vel2:Vector3DX = vel1.addScaled(acc1,_dt/2);
			var acc2:Vector3DX = getAcc(pos2,vel2); 
			// krok 3
			var pos3:Vector3DX = pos1.addScaled(vel2,_dt/2); 
			var vel3:Vector3DX = vel1.addScaled(acc2,_dt/2);
			var acc3:Vector3DX = getAcc(pos3,vel3); 
			// krok 4
			var pos4:Vector3DX = pos1.addScaled(vel3,_dt); 
			var vel4:Vector3DX = vel1.addScaled(acc3,_dt);
			var acc4:Vector3DX = getAcc(pos4,vel4); 
			// sumuje vel i acc
			var velsum:Vector3DX = vel1.addScaled(vel2,2).addScaled(vel3,2).addScaled(vel4,1);
			var accsum:Vector3DX = acc1.addScaled(acc2,2).addScaled(acc3,2).addScaled(acc4,1);
			// aktualizuje wartość położenia and velo
			_s = pos1.addScaled(velsum,_dt/6);
			_v = vel1.addScaled(accsum,_dt/6);			
			//_acc = accsum.multiply(1/6);
		}
		private function getAcc(ppos:Vector3DX,pvel:Vector3DX):Vector3DX{
			return new Vector3DX(0,_g,0);
		}
		
	}
}