package{
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.objects.Ball;
	
	import flash.display.Sprite;

	public class GravityField extends Sprite{
		public function GravityField():void{
			init();
		}
		private function init():void{
			var timeStep:Number = 10; // krok czasowy symulacji w milisekundach			
			var G:Number = 1; // Stała grawitacji			
			var c:Number = 300; // prędkość światła
			var numCenters:Number = 10; 
			
			// tworzy czarne dziury
			var centers:Array = new Array();
			for (var i:uint=0; i<numCenters; i++){
				var radius:Number=20*(Math.random()+0.5);
				var mass:Number=(0.5*c*c/G)*radius; // wzór pozwalający wyznaczyć masę czarnej dziury
				var center:Ball = new Ball(radius,0x000000,mass,0,false);	
				center.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
				addChild(center);		
				centers[i] = center;
			}

			// tworzy poruszające się ciało
			var orbiter:Ball= new Ball(5,0xff0000,1);	
			orbiter.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
			orbiter.velo2D = new Vector2D((Math.random()-0.5)*100,(Math.random()-0.5)*100);
			addChild(orbiter);

			// wprawia ciało w ruch
			var attractor:GravityAttractor=new GravityAttractor(orbiter,centers,G);		
			attractor.startTime(timeStep);
		}
	}
}