package{
	import flash.display.Sprite;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	
	import com.physicscodes.objects.Particle;

	public class CircularOrbits extends Sprite{
		public function CircularOrbits():void{
			init();
		}
		private function init():void{
			var G:Number = 1; // Stała grawitacji
			var sunMass:Number = 1000000;
			var planetMass:Number = 1;
			var distance:Number;
			var vMag:Number;
			
			// tworzy 100 rozmieszczonych losowo gwiazd
			for (var i:uint=0; i<100; i++){
				var star:Ball = new Ball(Math.random()*3,0xffff00);
				star.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
				addChild(star);
			}
			
			// tworzy nieruchomą gwiazdę
			var sun:Ball;
			sun = new Ball(60,0xff9900,sunMass);
			sun.pos2D = new Vector2D(400,300);			
			addChild(sun);

			// tworzy poruszającą się planetę			
			var planet:Ball;
			planet = new Ball(10,0x0000ff,planetMass);
			planet.pos2D = new Vector2D(400,50);
			//planet.pos2D = new Vector2D(400,150);
			
			distance = planet.pos2D.subtract(sun.pos2D).length;
			vMag = Math.sqrt(G*sunMass/distance);
			//trace(vMag);
			
			planet.velo2D = new Vector2D(vMag,0);			
			//planet.velo2D = new Vector2D(vMag/Math.sqrt(2),vMag/Math.sqrt(2));			
			addChild(planet);

			// wprawia planetę w ruch wokół gwiazdy
			var orbiter:Orbiter=new Orbiter(planet,sun,G);		
			orbiter.startTime();
		}
	}
}