package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;
	
	public class DampedOscillator2 extends Forcer{
		private var _object:Ball;
		private var _center:Vector2D;
		private var _graphX:Graph;
		private var _graphY:Graph;
		private var _displ:Vector2D;
		private var _kSpring:Number=10;
		private var _cDamping:Number=0.5;		
		private var _omega0:Number;
		private var _omegad:Number;
		private var _gamma:Number;		
		private var _A:Vector2D;
		private var _B:Vector2D;		

		public function DampedOscillator2(pobject:Ball,pattractor:Ball):void{
			_object = pobject;
            _center = pattractor.pos2D;
			_gamma = 0.5*_cDamping/Math.sqrt(_kSpring*_object.mass);
			_omega0 = Math.sqrt(_kSpring/_object.mass);
			_omegad = _omega0*Math.sqrt(1-_gamma*_gamma);
			_A = _object.pos2D.subtract(_center);
			_B = (_object.velo2D.add(_A.multiply(_gamma*_omega0))).multiply(1/_omegad);			
			setupGraphs();
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();		
			plotGraphs();
		}		
			
		override protected function calcForce():void{
            _displ=_object.pos2D.subtract(_center);
			var restoring:Vector2D = Forces.spring(_kSpring,_displ);
			var damping:Vector2D = Forces.damping(_cDamping,_object.velo2D);		
			force = Forces.add([restoring, damping]);
		}
		
		// tworzy wykres zależności przemieszczenia od czasu		
		private function setupGraphs():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graphX= new Graph(0,20,-250,250,50,200,450,100);					
			_graphX.drawgrid(5,1,250,50);			
			_graphX.drawaxes('time (s)','x displacement (px)');	
			_object.stage.addChild(_graphX);
			_graphY= new Graph(0,20,-250,250,50,375,450,100);					
			_graphY.drawgrid(5,1,250,50);			
			_graphY.drawaxes('time (s)','y displacement (px)');	
			_object.stage.addChild(_graphY);			
		}
		private function plotGraphs():void{
			_graphX.plot([time], [_displ.x], 0xff0000, false, true);
			_graphY.plot([time], [_displ.y], 0x0000ff, false, true);	
			var r:Vector2D = _A.multiply(Math.cos(_omegad*time)).add(_B.multiply(Math.sin(_omegad*time)));			
			r.scaleBy(Math.exp(-_gamma*_omega0*time));
			_graphX.plot([time], [r.x], 0x00ff00, false, true);
			_graphY.plot([time], [r.y], 0xff00ff, false, true);			
		}	
	}
}