package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Gravitator extends Forcer{
		
		private var _particleA:Particle;	
		private var _particleB:Particle;
		private var _G:Number = 100000;		
		private var _massA:Number;
		private var _massB:Number;		
		private var _r:Vector2D;

		public function Gravitator(pparticleA:Particle,pparticleB:Particle):void{
			_particleA = pparticleA;
			_particleB = pparticleB;
			_massA = pparticleA.mass;			
			_massB = pparticleB.mass;			
			super(pparticleA);
		}	
		
		override protected function calcForce():void{
			_r = _particleA.pos2D.subtract(_particleB.pos2D);
			force = Forces.gravity(_G,_massA,_massB,_r);			
		}
	}
}