package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class TestForcer extends Forcer{
		private var _particle:Particle;		
		private var _g:Number=10;
		private var _k:Number=0.1;
//		private var _k:Number=0.5;

		public function TestForcer(pparticle:Particle):void{
			_particle = pparticle;		
			super(pparticle);
		}	

		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var drag:Vector2D = Forces.linearDrag(_k,_particle.velo2D);
			//force = gravity;
			force = Forces.add([gravity, drag]);
		}
	
	}
}
