package {
	import flash.display.Sprite;	
	import flash.events.Event;
	
	public class BouncingBall3D extends Sprite {
		private var g:Number=0.1; // przyśpieszenie due to gravity
		private var vx:Number;  // initial horizontal speed
		private var vy:Number;  // initial vertical speed
		private var vz:Number;  // lateral speed
		private var ball:Ball;
		private var w:Number;
		private var gfac:Number=-0.99;
		private var wfac:Number=-0.99;

		public function BouncingBall3D() {
			init();
		}
		private function init():void {		
			vx = Math.random()*5;
			vy = (Math.random()-0.5)*4;
			vz = 4;
			ball = new Ball();	
			ball.x = 50;
			ball.y = 75;
			ball.z = 0;
			w = ball.width/2;
			addChild(ball);	
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // przyśpieszenie grawitacyjne increases the vertical speed
			
			ball.x += vx; // horizontal speed increases horizontal position
			ball.y += vy; // vertical speed increases vertical position
			ball.z += vz;
			
			if (ball.y > 350){ // if ball hits the ground
				ball.y = 350;
				vy *= gfac;    // its vertical velocity reverses and reduces
			}
			if (ball.x > 550 - w){
				ball.x = 550 - w;
				vx *= wfac;
			}
			if (ball.x < w){
				ball.x = w;
				vx *= wfac;
			}
			if (ball.z > 200){
				ball.z = 200;
				vz *= wfac;
			}
			if (ball.z < -200){
				ball.z = -200;
				vz *= wfac;
			}
			//trace(ball.z);
			//trace(vz);

		}
	}
}





