package {
	import com.physicscodes.motion.ForcerRB;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.RigidBody;		

	public class RigidBodyMover extends ForcerRB{
		private var _body:RigidBody;		
		private var _kLin:Number=0.1; // współczynnik tłumienia prędkości liniowej		
		private var _kAng:Number=0.5; // współczynnik tłumienia prędkości kątowej

		public function RigidBodyMover(pbody:RigidBody):void{
			_body = pbody;			
			super(pbody);
		}	
		
		// NB: należy podać zarówno siłę, jak i moment siły
		override protected function calcForce():void{
			force = Forces.zeroForce();
			force = force.addScaled(_body.velo2D,-_kLin); // tłumienie w ruchu postępowym
			torque = 1;
			torque += -_kAng*_body.angVelo; // tłumienie w ruchu obrotowym 
			trace(_body.angVelo);
		}
	}
}
