﻿package {
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	

	public class SpringGravityForcer extends MultiForcer{
				
		private var _center:Ball;		
		private var _G:Number=1;

		public function SpringGravityForcer(pparticles:Array,pcenter:Ball):void{
			_center = pcenter;
			super(pparticles);
		}	
		
		override protected function calcForce(pparticle:Particle):void{
			var k:Number = -_G*_center.mass*pparticle.mass;
			var n:Number = _center.charge;
			var r:Vector2D = pparticle.pos2D.subtract(_center.pos2D);	
			force = Forces.central(k,n,r);
		}
	}
}
