package com.physicscodes.motion{

	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.utils.getTimer;
	import com.physicscodes.objects.Particle;	

	public class Mover {

		private var _particle:Particle;
		private var _time:Number;
		private var _t0:Number;
		private var _dt:Number;
		private var _timer:Timer;
	
		public function Mover(pparticle:Particle):void {
			_particle = pparticle;
		}
		// TĘ FUNKCJĘ WYWOŁUJE SIĘ ZEWNĘTRZNIE, BY ZAINICJOWAĆ PROCEDURĘ TIMER I PRZECHWYTYWANIE ZDARZEŃ
		public function startTime(ptimestep:Number=20,psteps:Number=0):void {
			_timer=new Timer(ptimestep,psteps);
			_timer.addEventListener(TimerEvent.TIMER,onTimer);
			_timer.start();
			_time = 0;
			_t0 = getTimer();
		}
		public function stopTime():void {
			_timer.removeEventListener(TimerEvent.TIMER,onTimer);
			_timer.stop();
		}
		public function killTime():void {
			stopTime();
			if (_timer && _timer.running) _timer.stop();
			_timer=null;			
		}
		public function get time():Number {
			return _time;
		}
		public function get dt():Number {
			return _dt;
		}		
		// TĘ FUNKCJĘ WYWOŁUJE SIĘ PRZY KAŻDYM ZDARZENIU TIMER; OKREŚLA ONA KROK CZASOWY
		private function onTimer(pEvent:TimerEvent):void {
			_dt = 0.001 * (getTimer() - _t0);
			_time += _dt;
			_t0  =getTimer();
			moveObject();
			spinObject();
			pEvent.updateAfterEvent();						
		}
		protected function moveObject():void {
			//_particle.pos2D = _particle.pos2D.add(_particle.velo2D.multiply(_dt));		
			_particle.pos2D = _particle.pos2D.addScaled(_particle.velo2D,_dt);				
			//_particle.pos = _particle.pos.addScaled(_particle.velo,_dt);		
		}
		protected function spinObject():void{
			if (_particle.angVelo !=0){
				_particle.rotation += _particle.angVelo*_dt*180/Math.PI; 
			}
		}
		
	}
}