﻿package {	
	import com.physicscodes.motion.MultiMover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Collider extends MultiMover{
		
		private var _particles:Array;

		public function Collider(pparticles:Array):void{
			_particles = pparticles;
			super(pparticles);
		}			
		override protected function moveObject():void{
			super.moveObject();
			checkCollision();
		}		
		private function checkCollision():void{
			for (var i:uint=0; i<_particles.length; i++){
				var particle1:Particle = _particles[i];
				for (var j:Number=i+1; j<_particles.length; j++){				
					var particle2:Particle = _particles[j];				
					if (Vector2D.distance(particle1.pos2D,particle2.pos2D)<=0.5*(particle1.width+particle2.width)){						
						var vtemp:Vector2D = particle1.velo2D;
						particle1.velo2D = particle2.velo2D;
						particle2.velo2D = vtemp;						
					}
				}
			}			
		}
	}
}