package {
	import flash.display.Sprite;	
	import flash.utils.Timer;
	import flash.events.TimerEvent;	
	import flash.utils.getTimer;
	
	public class TimerExample extends Sprite {
		private var vx:Number=100; // prędkość podawana w px/s
		private var ball:Ball;
		private var timer:Timer;
		private var t:int;

		public function TimerExample() {
			init();
		}
		private function init():void {		
			createBall();
			setupTimer(); 
		}
		
		private function createBall():void{
			ball = new Ball();	
			ball.x = 50;
			ball.y = 100;
			addChild(ball);	
		}
		
		private function setupTimer():void{
			timer = new Timer(20);
			timer.addEventListener(TimerEvent.TIMER,onEachTimestep);		
			timer.start();
			t = getTimer(); // zainicjowanie wartości zmiennej t
		}

		private function onEachTimestep(evt:TimerEvent):void{
			var dt:Number = (getTimer() - t)/1000; // czas (w sekundach), jaki upłynął od poprzedniego wywołania
			t = getTimer(); // resetuje zmienną t 
			ball.x += vx*dt; 			
			evt.updateAfterEvent();
		}
	}
}





