package {
	import com.physicscodes.motion.MultiMover;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	
	public class MultiBallCollider extends MultiMover{
		private var _balls:Array;
		
		public function MultiBallCollider(pballs:Array) :void{
			_balls = pballs;
			super(_balls);
		}	
		  
		override protected function moveObject():void{
			super.moveObject();
			checkCollision();
		}
		
		private function checkCollision():void{
			for (var i:uint=0; i<_balls.length; i++){
				var ball1:Ball = _balls[i];
				for(var j:uint=i+1; j<_balls.length; j++){
					var ball2: Ball = _balls[j];
					var dist:Vector2D = ball1.pos2D.subtract(ball2.pos2D);
					if (dist.length < (ball1.radius +ball2.radius) ) {   		
						// wektory normalne prędkości tuż przed zderzeniem
						var normalVelo1:Vector2D = ball1.velo2D.project(dist);
						var normalVelo2:Vector2D = ball2.velo2D.project(dist);			
						// styczne wektoy prędkości
						var tangentVelo1:Vector2D = ball1.velo2D.subtract(normalVelo1);
						var tangentVelo2:Vector2D = ball2.velo2D.subtract(normalVelo2);
						// przemieszcza cząstki tak, by stykały się jedynie powierzchniami
						var L:Number = ball1.radius +ball2.radius-dist.length;
						var vrel:Number = normalVelo1.subtract(normalVelo2).length;
						ball1.pos2D = ball1.pos2D.addScaled(normalVelo1,-L/vrel);
						ball2.pos2D = ball2.pos2D.addScaled(normalVelo2,-L/vrel);						
						// prostopadłe składowe wektorów prędkości po zderzeniu
						var m1:Number = ball1.mass;
						var m2:Number = ball2.mass;
						var u1:Number = normalVelo1.projection(dist);
						var u2:Number = normalVelo2.projection(dist);			
						var v1:Number = ((m1-m2)*u1+2*m2*u2)/(m1+m2);
						var v2:Number = ((m2-m1)*u2+2*m1*u1)/(m1+m2);
						// normalne wektory prędkości po zderzeniu
						normalVelo1 = dist.para(v1);
						normalVelo2 = dist.para(v2);
						// wektory prędkości końcowych po zderzeniu
						ball1.velo2D = normalVelo1.add(tangentVelo1);
						ball2.velo2D = normalVelo2.add(tangentVelo2);
					}
				}
			}
		}
		
	}
}