package {
	import com.physicscodes.motion.MultiMover;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	
	public class BallCollider extends MultiMover{
		private var _ball1:Ball;
		private var _ball2:Ball;
		
		public function BallCollider(pball1:Ball,pball2:Ball) :void{
			_ball1 = pball1;
			_ball2 = pball2;
			super([_ball1,_ball2]);
		}	
		  
		override protected function moveObject():void{
			super.moveObject();
			checkCollision();
		}
		
		private function checkCollision():void{
			var dist:Vector2D = _ball1.pos2D.subtract(_ball2.pos2D);
			if (dist.length < (_ball1.radius +_ball2.radius) ) {   			
				// wektory normalne prędkości tuż przed zderzeniem
				var normalVelo1:Vector2D = _ball1.velo2D.project(dist);
				var normalVelo2:Vector2D = _ball2.velo2D.project(dist);			
				// styczne wektoy prędkości
				var tangentVelo1:Vector2D = _ball1.velo2D.subtract(normalVelo1);
				var tangentVelo2:Vector2D = _ball2.velo2D.subtract(normalVelo2);
				// przemieszcza cząstki tak, by stykały się jedynie powierzchniami
				var L:Number = _ball1.radius + _ball2.radius-dist.length;
				var vrel:Number = normalVelo1.subtract(normalVelo2).length;
				_ball1.pos2D = _ball1.pos2D.addScaled(normalVelo1,-L/vrel);
				_ball2.pos2D = _ball2.pos2D.addScaled(normalVelo2,-L/vrel);				
				// normal velocity components after the impact
				var m1:Number = _ball1.mass;
				var m2:Number = _ball2.mass;
				var u1:Number = normalVelo1.projection(dist);
				var u2:Number = normalVelo2.projection(dist);			
				var v1:Number = ((m1-m2)*u1+2*m2*u2)/(m1+m2);
				var v2:Number = ((m2-m1)*u2+2*m1*u1)/(m1+m2);
				// normalne wektory prędkości po zderzeniu
				normalVelo1 = dist.para(v1);
				normalVelo2 = dist.para(v2);
				// wektory prędkości końcowych po zderzeniu
				_ball1.velo2D = normalVelo1.add(tangentVelo1);
				_ball2.velo2D = normalVelo2.add(tangentVelo2);
			}			
		}
		
	}
}